/****************************************************************
Name: HighResEaser CCTEX MOD
Copyright: (c)2015, microdev
License: http://creativecommons.org/licenses/GPL/2.0/
Contact: microdev@gmx.net
Support: http://www.emutalk.net
****************************************************************/

// the file containing the texture markers and corresponding texture files
var TextureMarkerFilename = "TextureMarks.txt"
var HighResLayerName = "HighRes"
var VERSION = "1.6"
main()

function main(){
	// change the ruler units to the required ones
	var strtRulerUnits = app.preferences.rulerUnits; 
	var strtTypeUnits = app.preferences.typeUnits; 
	app.preferences.rulerUnits = Units.PIXELS; 
	app.preferences.typeUnits = TypeUnits.POINTS; 
	// open the main selection dialog
	MainDialog()
	// reset the ruler preferences to the original state
	app.preferences.rulerUnits = strtRulerUnits; 
	app.preferences.typeUnits = strtTypeUnits;

}

function  loadSelectedTextures(addHighRes, texturesToLoad, resizeFactor){
	// specify the folder from which the  textures will be loaded 
	var loadPath = Folder.selectDialog("Please specify the directory of the textures you want to open:")
	if(loadPath == null){
		alert("As no source texture folder has been choosen, the processing will be stopped.")
		return
	} 
	// load the texture mapping file to memory
	var mappingFile = readMetaFileFromPath(loadPath, TextureMarkerFilename)
	if(mappingFile == -1){
		var alternativeFile = File.openDialog("Please specify the file with the mapping information:",loadPath+"/.")
		if(alternativeFile == null){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
		// try loading the mapping information from the alternative path
		mappingFile = readMetaFile(alternativeFile)
		if(mappingFile == -1){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
	}
	// transfer mappings to hashtable
	var hashtable = createMappingsHashtable(mappingFile, loadPath)
	if(hashtable == -1){
		alert("Terminating script execution due to invalid mapping information.")
		return
	}
	// remove white spaces
	texturesToLoad = texturesToLoad.replace(/\s+/g,'')
	// split up the texture order information
	var displayOrder = texturesToLoad.split(",")

	var texture
	var docRef
	// load all textures at the appropriate place 
	for (var i = 0; i < displayOrder.length; i++) {
		// open the texture
		texture = openTexture(hashtable, displayOrder[i])
		if(texture == -1){
			alert("Terminating script execution due to missing textures.")
			return
		}
		// add a layer to the document
		docRef = app.activeDocument = texture; 
		// resize texture
		if(resizeFactor > 1){
			docRef.resizeImage(docRef.width*resizeFactor, docRef.height*resizeFactor)
		}
		// add high-res layer if configured
		if(addHighRes){
			var highResLayer = activeDocument.artLayers.add();
			highResLayer.name = HighResLayerName;
		} 
	}
} 


function arrangeTiles(textureOrder, rowCount, type, indent){
	if(type==0)
		arrangeBackground(textureOrder, rowCount)
	else
		arrangeSkybox(textureOrder, rowCount, type, indent)
}


function arrangeSkybox(textureOrder, rowCount, type, indent){
	
	// specify the folder from which the unmarked textures will be loaded 
	var loadPath = Folder.selectDialog("Please specify the directory of the textures you want to arrange:")
	if(loadPath == null){
		alert("As no source texture folder has been choosen, the processing will be stopped.")
		return
	} 
	// load the texture mapping file to memory
	var mappingFile = readMetaFileFromPath(loadPath, TextureMarkerFilename)
	if(mappingFile == -1){
		var alternativeFile = File.openDialog("Please specify the file with the mapping information:",loadPath+"/.")
		if(alternativeFile == null){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
		// try loading the mapping information from the alternative path
		mappingFile = readMetaFile(alternativeFile)
		if(mappingFile == -1){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
	}
	// transfer mappings to hashtable
	var hashtable = createMappingsHashtable(mappingFile, loadPath)
	if(hashtable == -1){
		alert("Terminating script execution due to invalid mapping information.")
		return
	}
	// remove white spaces
	textureOrder = textureOrder.replace(/\s+/g,'')
	// split up the texture order information
	var displayOrder = textureOrder.split(",")
	// create a new document
	var newDoc = app.documents.add(1,1)
	// and activate it
	app.activeDocument = newDoc
	var textureFile
	var texture
	var xPos
	var yPos
	var currentLayer
	var tileWidth = 0
	var tileHeight = 0
	var selectedArea
	var xAnchor = 0
	var yAnchor = 0
	var tileRow = 0
	var tileColumn = 0
	// load all textures at the appropriate place 
	for (var i = 0; i < indent*(rowCount-(2*indent)); i++) {

		if(displayOrder[i] == null){
			alert("Unsufficient numbers of tiles to complete skybox.\nNeeded "+(rowCount*rowCount-indent*indent*4)+" received "+displayOrder.length+" - Ending processing.");
			i= rowCount*rowCount;
			break;
		}
		// open the texture
		texture = openTexture(hashtable, displayOrder[i])
		if(texture == -1){
			alert("Terminating script execution due to missing textures.")
			return
		}

		// get the width of a tile
		tileWidth = texture.layers[0].bounds[2] - texture.layers[0].bounds[0]
		// get the higth of a tile
		tileHeight = texture.layers[0].bounds[3] - texture.layers[0].bounds[1]

		if((tileColumn%(rowCount-(2*indent))) == 0){
			// start new row
			if(i != 0)
				yAnchor += tileHeight;
			xAnchor = tileWidth*indent;
			tileColumn = 0;
		} else {
			//set anchor for next element in row
			xAnchor += tileWidth;
		}

		// rotate it by 180 grade
		texture.rotateCanvas(180, AnchorPosition.MIDDLECENTER); 
		// select its content
		texture.selection.selectAll(); 
		// and copy it to clipboard
		texture.selection.copy()
		// make the master document active
		app.activeDocument = newDoc
		// add a new layer to the master document
		currentLayer = newDoc.artLayers.add()
		// and activate it
		app.activeDocument.activeLayer = currentLayer
		// set the layer name to the name of the texture
		currentLayer.name = texture.name;
		// and resize it to the texture size
		currentLayer.bounds = texture.layers[0].bounds;
		if(i==0){
			// set the final size of the canvas
			newDoc.resizeCanvas((rowCount*tileWidth),(Math.ceil((displayOrder.length+(4*indent*indent))/rowCount))*tileHeight)
		}
		// mark the location on the master document to which the texture will be pasted
		selectedArea = Array(
			Array(xAnchor, yAnchor),
			Array(xAnchor+tileWidth, yAnchor),
			Array(xAnchor+tileWidth, yAnchor+tileHeight),
			Array(xAnchor, yAnchor+tileHeight),
			Array(xAnchor, yAnchor))	
		// select the area in the high res layer
		newDoc.selection.select(selectedArea,SelectionType.REPLACE)
		// past the texture into the new layer
		newDoc.paste()
		// and deselect it in the high res layer
		newDoc.selection.deselect() 
		// finally close the loaded texture
		texture.close(SaveOptions.DONOTSAVECHANGES);
		tileColumn++;
	}
	xAnchor = 0;
	tileColumn = 0;
	yAnchor += tileHeight;
	tileWidth = 0;
	tileHeight = 0;
	// load all textures at the appropriate place 
	for (; i < indent*(rowCount-(2*indent))+rowCount*(rowCount-(2*indent)); i++) {
	
		if(displayOrder[i] == null){
			alert("Unsufficient numbers of tiles to complete skybox.\nNeeded "+(rowCount*rowCount-indent*indent*4)+" received "+displayOrder.length+" - Ending processing.");
			i= rowCount*rowCount;
			break;
		}
		// open the texture
		texture = openTexture(hashtable, displayOrder[i])
		if(texture == -1){
			alert("Terminating script execution due to missing textures.")
			return
		}
		if((tileColumn%rowCount) == 0){
			// start new row
			yAnchor += tileHeight;
			xAnchor = 0;
			tileColumn=0;
			//alert("xAnchor="+xAnchor+" | yAnchor = "+yAnchor+" | tileColumn = "+tileColumn+" (reset)")
		} else {
			//set anchor for next element in row
			xAnchor += tileWidth;
		//	alert("xAnchor="+xAnchor+" | yAnchor = "+yAnchor+" | tileColumn = "+tileColumn)
		}
		// rotate texture if necessary
		if(tileColumn < indent)
			texture.rotateCanvas(90, AnchorPosition.MIDDLECENTER); 
		else{ 
			if(tileColumn > (rowCount-indent-1)){
			//alert("t:"+tileColumn+" > "+(rowCount-indent))
				texture.rotateCanvas(270, AnchorPosition.MIDDLECENTER); 
			}
		}
		// select its content
		texture.selection.selectAll(); 
		// and copy it to clipboard
		texture.selection.copy()
		// make the master document active
		app.activeDocument = newDoc
		// add a new layer to the master document
		currentLayer = newDoc.artLayers.add()
		// and activate it
		app.activeDocument.activeLayer = currentLayer
		// set the layer name to the name of the texture
		currentLayer.name = texture.name;
		// and resize it to the texture size
		currentLayer.bounds = texture.layers[0].bounds;
		// get the width of a tile
		tileWidth = texture.layers[0].bounds[2] - texture.layers[0].bounds[0]
		// get the higth of a tile
		tileHeight = texture.layers[0].bounds[3] - texture.layers[0].bounds[1]
		// mark the location on the master document to which the texture will be pasted
		selectedArea = Array(
			Array(xAnchor, yAnchor),
			Array(xAnchor+tileWidth, yAnchor),
			Array(xAnchor+tileWidth, yAnchor+tileHeight),
			Array(xAnchor, yAnchor+tileHeight),
			Array(xAnchor, yAnchor))	
		//alert("Selection="+selectedArea);
		// select the area in the high res layer
		newDoc.selection.select(selectedArea,SelectionType.REPLACE)
		// past the texture into the new layer
		newDoc.paste()
		// and deselect it in the high res layer
		newDoc.selection.deselect() 
		// finally close the loaded texture
		texture.close(SaveOptions.DONOTSAVECHANGES);
		tileColumn++;
	}
	xAnchor = 0;
	tileColumn = 0;
	//yAnchor += tileHeight;
	tileWidth = 0;
	tileHeight = 0;
	for (; i < displayOrder.length; i++) {

		if(displayOrder[i] == null){
			alert("Unsufficient numbers of tiles to complete skybox.\nNeeded "+(rowCount*rowCount-indent*indent*4)+" received "+displayOrder.length+" - Ending processing.");
			i= rowCount*rowCount;
			break;
		}
		// open the texture
		texture = openTexture(hashtable, displayOrder[i])
		if(texture == -1){
			alert("Terminating script execution due to missing textures.")
			return
		}

		// get the width of a tile
		tileWidth = texture.layers[0].bounds[2] - texture.layers[0].bounds[0]
		// get the higth of a tile
		tileHeight = texture.layers[0].bounds[3] - texture.layers[0].bounds[1]

		if((tileColumn%(rowCount-(2*indent))) == 0){
			// start new row
			yAnchor += tileHeight;
			xAnchor = tileWidth*indent;
			tileColumn = 0;
		} else {
			//set anchor for next element in row
			xAnchor += tileWidth;
		}

		// select its content
		texture.selection.selectAll(); 
		// and copy it to clipboard
		texture.selection.copy()
		// make the master document active
		app.activeDocument = newDoc
		// add a new layer to the master document
		currentLayer = newDoc.artLayers.add()
		// and activate it
		app.activeDocument.activeLayer = currentLayer
		// set the layer name to the name of the texture
		currentLayer.name = texture.name;
		// and resize it to the texture size
		currentLayer.bounds = texture.layers[0].bounds;
		// mark the location on the master document to which the texture will be pasted
		selectedArea = Array(
			Array(xAnchor, yAnchor),
			Array(xAnchor+tileWidth, yAnchor),
			Array(xAnchor+tileWidth, yAnchor+tileHeight),
			Array(xAnchor, yAnchor+tileHeight),
			Array(xAnchor, yAnchor))	
		// select the area in the high res layer
		newDoc.selection.select(selectedArea,SelectionType.REPLACE)
		// past the texture into the new layer
		newDoc.paste()
		// and deselect it in the high res layer
		newDoc.selection.deselect() 
		// finally close the loaded texture
		texture.close(SaveOptions.DONOTSAVECHANGES);
		tileColumn++;
	}
	// delete background layer
	 newDoc.backgroundLayer.remove()
	// add a new layer to the master document
	currentLayer = newDoc.artLayers.add()
	currentLayer.name = HighResLayerName
	return
} 

		
function arrangeBackground(textureOrder, rowCount){
	// specify the folder from which the unmarked textures will be loaded 
	var loadPath = Folder.selectDialog("Please specify the directory of the textures you want to arrange:")
	if(loadPath == null){
		alert("As no source texture folder has been choosen, the processing will be stopped.")
		return
	} 
	// load the texture mapping file to memory
	var mappingFile = readMetaFileFromPath(loadPath, TextureMarkerFilename)
	if(mappingFile == -1){
		var alternativeFile = File.openDialog("Please specify the file with the mapping information:",loadPath+"/.")
		if(alternativeFile == null){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
		// try loading the mapping information from the alternative path
		mappingFile = readMetaFile(alternativeFile)
		if(mappingFile == -1){
			alert("Terminating script execution due to missing mapping information.")
			return
		}
	}
	// transfer mappings to hashtable
	var hashtable = createMappingsHashtable(mappingFile, loadPath)
	if(hashtable == -1){
		alert("Terminating script execution due to invalid mapping information.")
		return
	}
	// remove white spaces
	textureOrder = textureOrder.replace(/\s+/g,'')
	// split up the texture order information
	var displayOrder = textureOrder.split(",")
	// create a new document
	var newDoc = app.documents.add(1,1)
	// and activate it
	app.activeDocument = newDoc
	var textureFile
	var texture
	var xPos
	var yPos
	var currentLayer
	var tileWidth = 0
	var tileHeight = 0
	var selectedArea
	var xAnchor = 0
	var yAnchor = 0
	var emptyElements = 0
	// load all textures at the appropriate place 
	for (var i = 0; i < displayOrder.length; i++) {
	
		// open the texture
		texture = openTexture(hashtable, displayOrder[i])
		if(texture == -1){
			alert("Terminating script execution due to missing textures.")
			return
		}
		if(((i%rowCount) == 0) && (i != 0)){
			// start new row
			yAnchor += tileHeight;
			xAnchor = 0;
		} else {
			//set anchor for next element in row
			xAnchor += tileWidth;
		}
		// select its content
		texture.selection.selectAll(); 
		// and copy it to clipboard
		texture.selection.copy()
		// make the master document active
		app.activeDocument = newDoc
		// add a new layer to the master document
		currentLayer = newDoc.artLayers.add()
		// and activate it
		app.activeDocument.activeLayer = currentLayer
		// set the layer name to the name of the texture
		currentLayer.name = texture.name;
		// and resize it to the texture size
		currentLayer.bounds = texture.layers[0].bounds;
		// get the width of a tile
		tileWidth = texture.layers[0].bounds[2] - texture.layers[0].bounds[0]
		// get the higth of a tile
		tileHeight = texture.layers[0].bounds[3] - texture.layers[0].bounds[1]
		if(i==0){
			// set the final size of the canvas
			//CCBUGFIX
			newDoc.resizeCanvas((rowCount*texture.width),(Math.ceil(displayOrder.length/rowCount))*tileHeight)
			//newDoc.resizeCanvas((rowCount*tileWidth),(Math.ceil(displayOrder.length/rowCount))*tileHeight)
			//CCBUGFIX
		}
		// mark the location on the master document to which the texture will be pasted
		selectedArea = Array(
			Array(xAnchor, yAnchor),
			Array(xAnchor+tileWidth, yAnchor),
			Array(xAnchor+tileWidth, yAnchor+tileHeight),
			Array(xAnchor, yAnchor+tileHeight),
			Array(xAnchor, yAnchor))
		// select the area in the high res layer
		newDoc.selection.select(selectedArea,SelectionType.REPLACE)
		// past the texture into the new layer
		newDoc.paste()
		// and deselect it in the high res layer
		newDoc.selection.deselect() 
		// finally close the loaded texture
		texture.close(SaveOptions.DONOTSAVECHANGES);
		// reset the counter for the empty elements
		emptyElements = 0;
	}
	// delete background layer
	 newDoc.backgroundLayer.remove()
	// add a new layer to the master document
	currentLayer = newDoc.artLayers.add()
	currentLayer.name = HighResLayerName
	return
} 

function openTexture(hashtable, index){
	if(hashtable == null){
		alert("openTexture(): no argument provided for parameter \"hashtable\"")
		return -1;
	}
	if(index == null){
		alert("openTexture(): no argument provided for parameter \"index\"")
		return -1;
	}

	// get the right texture for the next position
	//var textureFile = new File("\""+File.decode(getFromHashtable(hashtable, index))+"\"")
	var textureFile = new File(File.decode(getFromHashtable(hashtable, index)))
	// check if texture file actually exists
	if (!textureFile.exists){
		alert("unable to find texture file \"" + textureFile.fsName+"\".")
		// second chance: allow to specify a path for the texture file that is not mentioned in the mapping information
		var alternativeFile = File.openDialog("Alternative file for \""+textureFile.fsName+"\":","Textures:*.PNG;*.png,All files:*")
		if(alternativeFile == null){	
			return -1;
		}
		// create file handle
		textureFile = new File(alternativeFile)
		// check if the texture exists in the new path
		if (!textureFile.exists){
			alert("Also the alternative texture file \""+textureFile.fsName+"\" does not exist.")
			return -1
		}
	}
	// try to open the texture file
	if (!textureFile.open('r')){
		alert("unable to open texture file \"" + textureFile.fsName+"\" for reading.");
		return -1;
	}
	// open the texture
	var texture = open(textureFile)
	texture.name = textureFile.name;
	return texture
}

function saveMetaFile(MetaDataInformation, DestinationPath){
	// validate parameters
	if (!MetaDataInformation || !DestinationPath) { 
		return; 
	} 
	// create meta data file in target folder
	var targetLocation = new File(DestinationPath+"/"+TextureMarkerFilename); 
	// validate if it worked
	if (!targetLocation) { 
		throw "Unable to create meta data file \"" + DestinationPath+"/"+TextureMarkerFilename+"\"."; 
	} 
	// open meta file for writing
	if (!targetLocation.open("w")) { 
		throw "Unable to open meta data file " + targetLocation + ": " + targetLocation.error; 
	} 
	// write meta data to file
	targetLocation.write(MetaDataInformation); 
	// and close it
	targetLocation.close(); 
}

function readMetaFileFromPath(textureFolder, textureFile) {
	return readMetaFile(textureFolder+"/"+textureFile);
}

function readMetaFile(texturePath){
	// var for mapping information
	var textureMarksMapping
	// create file object
	var textureMarks = new File(texturePath)

	// check if file exists
	if (!textureMarks.exists){alert('Texture id mapping information file does not exist\n' + textureMarks.fsName);return -1;}
	// it does. now check if it is readable
	if (!textureMarks.open('r')) {alert('Failed to read the texture id mapping information\n' + textureMarks.fsName);return -1;}
	// read mappings
	textureMarksMapping = textureMarks.read();
	// close the file
	textureMarks.close();
	// and return mapping information
	return textureMarksMapping;
}

function createHashtable() { 
	var hashtable = new Object(); 
	return hashtable
}

function addToHashtable(hashtable, key, value) { 
	if(hashtable == null)
	alert("addToHashtable(): no argument provided for parameter \"hashtable\"")
	if(key == null)
	alert("addToHashtable(): no argument provided for parameter \"key\"")
	
	// add value to hashtable
	 hashtable[key] = value; 
}

function getFromHashtable(hashtable, key){
	if(hashtable == null)
	alert("getFromHashtable(): no argument provided for parameter \"hashtable\"")
	if(key == null)
	alert("getFromHashtable(): no argument provided for parameter \"key\"")
	
	// add value to hashtable
	 return hashtable[key]; 
}

function createMappingsHashtable(mappingInformation, texturePath){
	if(mappingInformation == null)
	alert("createMappingsHashtable(): no argument provided for parameter \"mappingInformation\"")

	// split the mapping lines
	var mappings = mappingInformation.split("\n")
	// create hashtable instance
	var hashtable = createHashtable()
	var mapping
	
	// add each mapping to hashtable
	for(var i=0;i<mappings.length; i++) {
		// separate key value pair
		mapping = mappings[i].split(" ")
		if(mapping.length != 2){
			alert("the mapping \""+mappings[i]+"\" is invalid!")
			return -1;
		}
		// and add it to the hashtable
		addToHashtable(hashtable, mapping[0], texturePath+"/"+File.decode(mapping[1]))
	}   
	return hashtable;
}

function splitHighRes(){
	// Reference to the document we want to jigsaw
	var docRef = app.documents[0]
	// determine how many jigsaw elements are there
	var numberOfPieces = docRef.layers.length
	// This is the layer with the highres art
	var highRes = docRef.layers[0]
	// Rectangle coordinates of one element
	var xPos1
	var yPos1
	var xPos2
	var yPos2
	var newDoc
	var currentLayer
	// the selected rectangle
	var selectedArea
	// specify the folder, the high res parts will be saved to
	var savePath = Folder.selectDialog("Please specify the highres save path:")
	if(savePath == null){
		alert("As no folder has been choosen to export the highres-textures, the processing will be stopped.")
		return
	} 
	// create a chunk for every texture
	for(i = 1; i < numberOfPieces; i=i+1) 
	{
		// make the document we like to treat the active one
		app.activeDocument = docRef
		// allways set the high res layer as the active one
		app.activeDocument.activeLayer = highRes
		if(docRef.layers[i].isBackgroundLayer){
			alert("Layer \""+docRef.layers[i].name+"\" is the background layer - skipping.")
			continue;
		}
		// get the coordinates of the texture
		xPos1 = docRef.layers[i].bounds[0].value
		yPos1 = docRef.layers[i].bounds[1].value
		xPos2 = docRef.layers[i].bounds[2].value
		yPos2 = docRef.layers[i].bounds[3].value
		// define the area that will be selected
		selectedArea = Array(Array(xPos1,yPos1),Array(xPos2,yPos1),Array(xPos2,yPos2),Array(xPos1,yPos2),Array(xPos1,yPos1))
		// select the area in the high res layer
		docRef.selection.select(selectedArea,SelectionType.REPLACE)
		// copy it to clipboard
		docRef.selection.copy()
		// and deselect it in the high res layer
		docRef.selection.deselect() 
		// create a new document with the size of the data from the clipboard
		newDoc = app.documents.add((xPos2-xPos1),(yPos2-yPos1),docRef.resolution, docRef.layers[i].name)
		// add a new layer to the master document
		currentLayer = newDoc.artLayers.add()
		// and activate it
		app.activeDocument.activeLayer = currentLayer
		// paste clipboard to new document
		newDoc.paste()
		// delete background layer
		 newDoc.backgroundLayer.remove()
		// export the document as texture to the destination folder and close it afterwards
		saveTexture(newDoc, savePath)
	}
	alert("sliced layer \""+docRef.layers[0].name+"\" into "+(numberOfPieces-1)+" chunks and saved them to \""+savePath+"\"")
}





function markTextures(ParFontSize, ParAutomaticSize, ParColor, ParScaleFactor, ParIdPosition){


	//CCEXP
	// specify the folder from which the unmarked textures will be loaded 

	var loadPath;
	if(ParColor != 6)	
		loadPath = Folder.selectDialog("Please specify the directory of textures to be modified:")
	else
		loadPath = Folder.selectDialog("Please specify the directory containing your screenshot:")	
	if(loadPath == null){
		alert("As no source texture folder has been choosen, the processing will be stopped.")
		return
	} 

	// specify the folder, the high res parts will be saved to
	var savePath;
	if(ParColor!=6) {
		savePath = Folder.selectDialog("Please specify the save path for the marked textures:", loadPath)
		if(savePath == null){
			alert("As no destination texture folder has been choosen, the processing will be stopped.")
			return
		} 
	}
	else {
		savePath=loadPath;
	}
	//CCEXP
	// this string will hold the meta information
	var MetaData = ""	
	// the first ID that will be assigned
	var textureID = 1
	// only load PNG textures
	var textureList = loadPath.getFiles("*.PNG",'*.png'); 
	var currentTexture
	// open all textures in folder 
	for (var i = 0; i < textureList.length; i++) { 
	
		//The filelist includes both folders and files, open only files 
		if (textureList[i] instanceof File && textureList[i].hidden == false) { 
			// avoid adding a newline before the meta file contains the first entry
			if(MetaData.length != 0){
				MetaData += "\n"
			}
			// add the id to the texture
			//CCEXP
			if (ParColor==6)
				currentTexture = Experimental(textureList[i], (i+1), ParFontSize, ParAutomaticSize, ParColor, ParScaleFactor, ParIdPosition); 					
			else
				currentTexture = addMarker(textureList[i], (i+1), ParFontSize, ParAutomaticSize, ParColor, ParScaleFactor, ParIdPosition); 									
			//CCEXP
			// and store the information in the meta file
			MetaData += (i+1) + " "+ textureList[i].name
			// save the marked texture to the destination path	
			//CCEXP
			if (ParColor!=6)
				saveTexture(currentTexture, savePath)
			//CCEXP
		}
	} 

	//CCEXP
	if(ParColor!=6)
	{
	// finally save the meta data file to the destination path
	saveMetaFile(MetaData, savePath)
	// and as well to the source path, so unmarked textures can be arranged easily
	saveMetaFile(MetaData, loadPath)

	alert("Saved "+textureList.length+" marked texture to \""+savePath+"\"")
	}
	//CCEXP
} // main()


	//CCEXP
function Experimental(texture, marker, fontSize, autoSize, fontColor, scaleFactor, idPosition) {
	
	// load the texture in a new document
	var docRef = open(texture); 
	
	
	//var textColor = new SolidColor; 
	// get the font size of the id
	//var textSize = fontSize
	var textLayerWidth
	var xPos = 0
	// add a layer to the document
	app.activeDocument = docRef; 
	// get texture dimensions	
	
    var slices = prompt("How many textures in the screenshot to be decoded?", "10");
	var slicesint = parseInt(slices);
	var xoffset=prompt("Please enter the horizontal offset (px) for color sampling. Leave alone unless you know what you're doing.", "1");
	var xoffsetint=parseInt(xoffset);
	var theSampler;
	var height = docRef.layers[0].bounds[3].value - docRef.layers[0].bounds[1].value;
	var autocsv = "";
	var autonum =0;
	var pr;
	var pg;
	var pb;
	for (var i = 0; i < slicesint; i++) {
		theSampler = app.activeDocument.colorSamplers.add([xoffsetint,(i*(height/slicesint))+((height/slicesint)/2)]);

		if(theSampler.color.rgb.red < 25.5 )
			pr=0;
		if(theSampler.color.rgb.red >= 25.5 && theSampler.color.rgb.red < 51 )
			pr=1;
		if(theSampler.color.rgb.red >= 51 && theSampler.color.rgb.red < 76.5 )
			pr=2;
		if(theSampler.color.rgb.red >= 76.5 && theSampler.color.rgb.red < 102 )
			pr=3;
		if(theSampler.color.rgb.red >= 102 && theSampler.color.rgb.red < 127.5 )
			pr=4;
		if(theSampler.color.rgb.red >= 127.5 && theSampler.color.rgb.red < 153 )
			pr=5;
		if(theSampler.color.rgb.red >= 153 && theSampler.color.rgb.red < 178.5 )
			pr=6;
		if(theSampler.color.rgb.red >= 178.5 && theSampler.color.rgb.red < 204 )
			pr=7;
		if(theSampler.color.rgb.red >= 204 && theSampler.color.rgb.red < 229.5 )
			pr=8;
		if(theSampler.color.rgb.red >= 229.5)
			pr=9;

		if(theSampler.color.rgb.green < 25.5 )
			pg=0;
		if(theSampler.color.rgb.green >= 25.5 && theSampler.color.rgb.green < 51 )
			pg=1;
		if(theSampler.color.rgb.green >= 51 && theSampler.color.rgb.green < 76.5 )
			pg=2;
		if(theSampler.color.rgb.green >= 76.5 && theSampler.color.rgb.green < 102 )
			pg=3;
		if(theSampler.color.rgb.green >= 102 && theSampler.color.rgb.green < 127.5 )
			pg=4;
		if(theSampler.color.rgb.green >= 127.5 && theSampler.color.rgb.green < 153 )
			pg=5;
		if(theSampler.color.rgb.green >= 153 && theSampler.color.rgb.green < 178.5 )
			pg=6;
		if(theSampler.color.rgb.green >= 178.5 && theSampler.color.rgb.green < 204 )
			pg=7;
		if(theSampler.color.rgb.green >= 204 && theSampler.color.rgb.green < 229.5 )
			pg=8;
		if(theSampler.color.rgb.green >= 229.5)
			pg=9;

		if(theSampler.color.rgb.blue < 25.5 )
			pb=0;
		if(theSampler.color.rgb.blue >= 25.5 && theSampler.color.rgb.blue < 51 )
			pb=1;
		if(theSampler.color.rgb.blue >= 51 && theSampler.color.rgb.blue < 76.5 )
			pb=2;
		if(theSampler.color.rgb.blue >= 76.5 && theSampler.color.rgb.blue < 102 )
			pb=3;
		if(theSampler.color.rgb.blue >= 102 && theSampler.color.rgb.blue < 127.5 )
			pb=4;
		if(theSampler.color.rgb.blue >= 127.5 && theSampler.color.rgb.blue < 153 )
			pb=5;
		if(theSampler.color.rgb.blue >= 153 && theSampler.color.rgb.blue < 178.5 )
			pb=6;
		if(theSampler.color.rgb.blue >= 178.5 && theSampler.color.rgb.blue < 204 )
			pb=7;
		if(theSampler.color.rgb.blue >= 204 && theSampler.color.rgb.blue < 229.5 )
			pb=8;
		if(theSampler.color.rgb.blue >= 229.5)
			pb=9;

		autonum = pr+(pg*10)+(pb*100);
		autocsv = autocsv + autonum.toString();
		if (i+1 < slicesint)
			autocsv = autocsv + ",";
		//alert (theSampler.color.rgb.red+"_"+theSampler.color.rgb.green+"_"+theSampler.color.rgb.blue);
		app.activeDocument.colorSamplers[0].remove();	
	}
	alert("Successfully decoded texture sequence from "+slices+" values!");
	docRef.close(SaveOptions.DONOTSAVECHANGES);
	TextureArrangementDialog(autocsv);

}
	//CCEXP

function addMarker(texture, marker, fontSize, autoSize, fontColor, scaleFactor, idPosition){

	// load the texture in a new document
	var docRef = open(texture); 
	
	
	var textColor = new SolidColor; 
	// get the font size of the id
	var textSize = fontSize
	var textLayerWidth
	var xPos = 0
	// add a layer to the document
	app.activeDocument = docRef; 
	// get texture dimensions
	
	
	
	
	
	
	
	var width = docRef.layers[0].bounds[2].value - docRef.layers[0].bounds[0].value
	var height = docRef.layers[0].bounds[3].value - docRef.layers[0].bounds[1].value
	// resize texture
	docRef.resizeImage(docRef.width*scaleFactor, docRef.height*scaleFactor)
	// get dimensions of the resized texture
	height = docRef.layers[0].bounds[3].value - docRef.layers[0].bounds[1].value
	width = docRef.layers[0].bounds[2].value - docRef.layers[0].bounds[0].value
	
	//CCTEX MOD START
	if (fontColor == 5) {
		var rectlayer = activeDocument.artLayers.add();
		textColor.rgb.red=255;
    	textColor.rgb.green=255;
    	textColor.rgb.blue=255;
    	selectedRegion = Array(Array(0,0), Array(0, app.activeDocument.height), Array(app.activeDocument.width, app.activeDocument.height), Array(app.activeDocument.width, 0));
    	activeDocument.selection.select(selectedRegion);
    	activeDocument.selection.fill(textColor);
    	activeDocument.selection.deselect();
    	app.activeDocument.mergeVisibleLayers()
	}
	//CCTEX MOD STOP



	var txtLayer = activeDocument.artLayers.add();
	var colorR = 255;
	var colorB = 0;
	var colorG = 0;
	
	// create color
	switch (parseInt(fontColor)) {
		case 0:
			colorR= 255; colorG= 0; colorB=0;
			break;
		case 1:
			colorR= 0; colorG= 0; colorB=0;
			break;
		case 2:
			colorR= 255; colorG= 255; colorB=255
			break;
		case 3:
			colorR= 0; colorG= 0; colorB=255;
			break;
		case 4:
			colorR= 0; colorG= 255; colorB=0;
			break;
		//CCTEX MOD START
		case 5:
			colorR= 255; colorG= 0; colorB=0;
			break;		
		//CCTEX MOD STOP
		//CCEXP
		case 6:
			colorR= 0; colorG= 0; colorB=0;
			break;
		case 7:
			colorR= 0; colorG= 0; colorB=0;
			break;	
		//CCEXP		
		default:
			alert("should not be shown - shit!")
	} 	
	switch (idPosition) {
		case 0:
			xPos = 0;
			break;
		case 1:
			xPos = width/2;
			break;
		//CCTEX MOD START
		case 2:
			xPos = 0;
			break;		
		//CCTEX MOD STOP	
		default:
			alert("should not be shown - shit!")
	} 
	// define id color
	textColor.rgb.red = colorR; 
	textColor.rgb.green = colorG; 
	textColor.rgb.blue = colorB; 
	// define ID layer parameters

	txtLayer.kind = LayerKind.TEXT; 

	//CCTEX MOD START
	var tens=Math.floor(marker/10);
	var fives=Math.floor((marker-(tens*10))/5);
	var ones=marker-((tens*10)+(fives*5));

	if (idPosition == 2 && fontColor !=7) {

		for (var i = 0; i < (ones+fives+tens); i++) {
			txtLayer.textItem.contents += "n";
		}

	} else {

		txtLayer.textItem.contents = marker;

	}
	//CCTEX MOD STOP

	txtLayer.textItem.position = Array(xPos, height); 

	//CCTEX MOD START
	if (idPosition == 2) {
		textColor.rgb.red=255;
		textColor.rgb.green=0;
		textColor.rgb.blue=0;
		txtLayer.textItem.font = "Webdings";
	} else {
		txtLayer.textItem.font = "ComicSansMS";
	}
	//CCTEX MOD STOP
	
	if(autoSize){
		// set size automatically corresponding to the texture size
		textSize = (height < width) ? height : width; 
		// restrict maximum font size
		textSize = (textSize > 99) ? 99: textSize;
	}
	txtLayer.textItem.size = textSize; 
	txtLayer.textItem.color = textColor; 
	if(autoSize){
		textLayerWidth = txtLayer.bounds[2].value - txtLayer.bounds[0].value
		// if the id is too wide, shrink it to fit
		if(textLayerWidth > width){
			txtLayer.resize(width,(txtLayer.bounds[3].value - txtLayer.bounds[1].value))
		}
	}
	


	//merge the original texture with the id layer
	app.activeDocument.mergeVisibleLayers()

	//CCTEX MOD START
	if (idPosition == 2 && fives > 0 && fontColor !=7) {
		var fivLayer = activeDocument.artLayers.add();
		fivLayer.kind = LayerKind.TEXT; 
		fivLayer.textItem.position = Array(xPos, height);
		for (var i = 0; i < (fives+tens); i++) {
			fivLayer.textItem.contents += "n";
		}
		textColor.rgb.red=0;
		textColor.rgb.green=0;
		textColor.rgb.blue=255;
		fivLayer.textItem.font = "Webdings";
		fivLayer.textItem.size = textSize; 
		fivLayer.textItem.color = textColor;


	if(autoSize){
		textLayerWidth = fivLayer.bounds[2].value - fivLayer.bounds[0].value
		if(textLayerWidth > width){
			fivLayer.resize(width,(fivLayer.bounds[3].value - fivLayer.bounds[1].value))
		}
	}

		app.activeDocument.mergeVisibleLayers()
	}

	if (idPosition == 2 && tens > 0 && fontColor !=7) {
		var tenLayer = activeDocument.artLayers.add();
		tenLayer.kind = LayerKind.TEXT; 
		tenLayer.textItem.position = Array(xPos, height);
		for (var i = 0; i < tens; i++) {
			tenLayer.textItem.contents += "n";
		}
		textColor.rgb.red=0;
		textColor.rgb.green=255;
		textColor.rgb.blue=0;
		tenLayer.textItem.font = "Webdings";
		tenLayer.textItem.size = textSize; 
		tenLayer.textItem.color = textColor;


	if(autoSize){
		textLayerWidth = tenLayer.bounds[2].value - tenLayer.bounds[0].value
		if(textLayerWidth > width){
			tenLayer.resize(width,(tenLayer.bounds[3].value - tenLayer.bounds[1].value))
		}
	}

		app.activeDocument.mergeVisibleLayers()
	}
	//CCTEX MOD STOP	

	//CCEXP
	if (fontColor == 7) {
		var robohun=Math.floor(marker/100);
		var roboten=Math.floor((marker-(robohun*100))/10);
		var roboone=marker % 10;
		var explayer = activeDocument.artLayers.add();
		textColor.rgb.red=(roboone*25.5)+12.75;
    	textColor.rgb.green=(roboten*25.5)+12.75;
    	textColor.rgb.blue=(robohun*25.5)+12.75;
		//textColor.rgb.red=1;
    	//textColor.rgb.green=1;
    	//textColor.rgb.blue=1;    	
    	selectedRegion = Array(Array(0,0), Array(0, app.activeDocument.height), Array(app.activeDocument.width, app.activeDocument.height), Array(app.activeDocument.width, 0));
    	activeDocument.selection.select(selectedRegion);
    	activeDocument.selection.fill(textColor);
    	activeDocument.selection.deselect();
    	app.activeDocument.mergeVisibleLayers()
	}
	//CCEXP



	return docRef
}


function saveTexture(DocumentToSave, DestinationPath){
	// get the filename
	var fileName = DocumentToSave.name
	// check if file name comes with the right format extension
	if(fileName.toUpperCase().indexOf(".PNG") != (fileName.length-4)){
		fileName += ".png"
	}
	// generate absolute filename
	fileName = DestinationPath+"/"+fileName;
	//create the texture file in the destination directory
	targetLocation = new File(fileName); 	
	// save to file 
	DocumentToSave.saveAs(targetLocation, new PNGSaveOptions()); 
	// close everything
	targetLocation.close()
	DocumentToSave.close(SaveOptions.DONOTSAVECHANGES)
}

//CCEXP
function TextureArrangementDialog(Roboread)
{
//CCEXP
	var conditionStr =
			"dialog { text: 'HighResEaser CCTEX MOD v"+VERSION+"', bounds:[140,50,570,360], " + 
			"Parameters: Panel { text: 'Texture arrangement parameters', bounds:[10,10,420,260], " +
				"TypeSt: StaticText { text:'Type', helpTip:'Select if you want to work on a background/logo or a skybox.', justify:'right', bounds:[15,15,80,30]}, " +		
				"TypeDd: DropDownList { text:'', properties:{multiline:true}, bounds:[95,15,220,35]}, " +
				"fsRcSt: StaticText { text:'Tiles per row', helpTip:'Here you have to enter the width (=length) of the background/logo/skybox in tiles. For the skybox the width without edges is necessary, meaning the longest width.' , justify:'right', bounds:[15,45,80,60]}, " +
				"fsRcEt: EditText { text:'', bounds:[95,45,115,60]}, " +
				"IndentSt: StaticText { text:'Indent', justify:'right', helpTip:'Defines how many tiles the skybox is indented. (means the length of the edges of the skybox)', bounds:[135,45,180,60]}, " +
				"IndentEt: EditText { text:'', bounds:[190,45,210,60]}, " +
				"fsToSt: StaticText { text:'Tile order', helpTip:'A comma-separated list with the ids of the texture you want to load. You can create this list by loading the marked textures into your emulator and noting the order of the textures in the game.', justify:'right', bounds:[15,75,80,90]}, " +		
				"fsToEt: EditText { text:'', properties:{multiline:true}, bounds:[95,75,400,230]}, " +
			"}, " +
			"cancelBtn: Button { text:'Cancel', bounds:[15,275,115,295]}, " + 
			"runBtn: Button { text:'RUN', bounds:[315,275,415,295]}, " + 
	"}";

	var w = new Window(conditionStr);
	w.Parameters.TypeDd.add('item', "Background/Logo")
	w.Parameters.TypeDd.add('item', "Skybox")
	w.Parameters.TypeDd.selection = w.Parameters.TypeDd.items[0] 
	w.center();
	//CCEXP
	if(Roboread!="NoRobo")
		w.Parameters.fsToEt.text=Roboread;
	//CCEXP
	w.cancelBtn.onClick = function () {w.close(-1);}
	w.Parameters.fsRcEt.onChanging = function(){
		w.Parameters.fsRcEt.text = w.Parameters.fsRcEt.text.replace(/[^\d]+/g,'');
	}
	w.Parameters.fsToEt.onChanging = function(){
		w.Parameters.fsToEt.text = w.Parameters.fsToEt.text.replace(/[^\n\r\d ,]+/g,'');
	}
	w.cancelBtn.onClick = function () {w.close(-1);}

	w.Parameters.TypeDd.onChange = function() {
		w.Parameters.IndentSt.visible = (w.Parameters.TypeDd.selection == 1);
		w.Parameters.IndentEt.visible = (w.Parameters.TypeDd.selection == 1);
	}

	w.runBtn.onClick = function () {
		if (!w.Parameters.fsRcEt.text){
			alert("No number of tiles per row has been specified ");
			return;
		}
		if (w.Parameters.fsRcEt.text < 1){
			alert(w.Parameters.fsRcEt.text+" number of tiles per row is an invalid value.\nThere has to be at least 1 tile per row (logic isn't it?)");
			return;
		}
		if ((w.Parameters.TypeDd.selection == 1) && !w.Parameters.IndentEt.text){
			alert("No indent for the skybox has been specified ("+w.Parameters.IndentEt.text+")");
			return;
		}
		if ((w.Parameters.TypeDd.selection == 1) && (w.Parameters.IndentEt.text < 1)){
			alert("The indent "+w.Parameters.IndentEt.text+" is an invalid value for the skybox.\nThere has to be at least 1 tile as indent (logic isn't it?) ("+w.Parameters.IndentEt.text+")");
			return;
		}
		if (!w.Parameters.fsToEt.text){
			alert("The tile order is missing");
			return;
		}
		if (w.Parameters.fsToEt.text.length < 1){
			alert("At least 1 tile id has to be specified");
			return;
		}
		w.close(1);
		arrangeTiles(w.Parameters.fsToEt.text, w.Parameters.fsRcEt.text, parseInt(w.Parameters.TypeDd.selection), w.Parameters.IndentEt.text);
	}
	dlg = w.show();
	return w;
}

function MarkTextureDialog()
{
	var conditionStr =
			"dialog { text: 'HighResEaser CCTEX MOD v"+VERSION+"', bounds:[140,50,380,250], " + 
			"Parameters: Panel { text: 'Texture marking parameters', bounds:[10,10,230,160], " +
				"TmTsSt: StaticText { text:'font size',helpTip:'Allows you to manually specify the font size of the texture ids. This is just possible if the automatic-checkbox is unchecked.', justify:'right', bounds:[15,15,80,30]}, " +
				"TmTsEt: EditText { text:'', enabled:false, bounds:[95,15,125,35]},  " +
				"TmTsAutoCb: Checkbox { text:'automatic',helpTip:'Tries to detect the size for the teture marks automatically.', value:true, bounds:[130,15,200,35]}, " +
				"TmRsfSt: StaticText { text:'Texture resize factor',helpTip:'Besides marking the textures it is also possible to resize them. Multiples of two are allowed (up to 16x)', justify:'right', bounds:[15,45,80,60]}, " +
				"TmRsfEt: DropDownList { text:'', properties:{multiline:true}, bounds:[95,45,145,65]}, " +
				"TmFcSt: StaticText { text:'font color',helpTip:'Allows you to specify the color of the texture ids.', justify:'right', bounds:[15,75,80,90]}, " +		
				"TmFcDd: DropDownList { text:'', properties:{multiline:true}, bounds:[95,75,180,95]}, " +
				"TmPosSt: StaticText { text:'ID position',helpTip:'Here you can decide where on the texture the id will be placed.', justify:'right', bounds:[15,110,80,135]}, " +		
				"TmPosDd: DropDownList { text:'', properties:{multiline:true}, bounds:[95,110,180,130]}, " +
			"}, " +
			"cancelBtn: Button { text:'Cancel', bounds:[15,170,75,190]}, " + 
			"runBtn: Button { text:'RUN', bounds:[165,170,225,190]}, " + 
	"}";

	var w = new Window(conditionStr);
	w.Parameters.TmFcDd.add('item', "red")
	w.Parameters.TmFcDd.add('item', "black")
	w.Parameters.TmFcDd.add('item', "white")
	w.Parameters.TmFcDd.add('item', "blue")
	w.Parameters.TmFcDd.add('item', "green")
	//CCTEX MOD START
	w.Parameters.TmFcDd.add('item', "NO BG")	
	//CCTEX MOD STOP
	//CCEXP
	w.Parameters.TmFcDd.add('item', "ROBOREAD")
	w.Parameters.TmFcDd.add('item', "ROBOWRITE")
	//CCEXP	
	w.Parameters.TmFcDd.selection = w.Parameters.TmFcDd.items[0] 
	w.Parameters.TmRsfEt.add('item', "none")
	w.Parameters.TmRsfEt.add('item', "2x")
	w.Parameters.TmRsfEt.add('item', "4x")
	w.Parameters.TmRsfEt.add('item', "8x")
	w.Parameters.TmRsfEt.add('item', "16x")
	w.Parameters.TmRsfEt.selection = w.Parameters.TmRsfEt.items[2] 
	w.Parameters.TmPosDd.add('item', "left")
	w.Parameters.TmPosDd.add('item', "center")
	//CCTEX MOD START
	w.Parameters.TmPosDd.add('item', "HICONTRAST")
	//CCTEX MOD STOP
	w.Parameters.TmPosDd.selection = w.Parameters.TmPosDd.items[0] 
	w.cancelBtn.onClick = function () {w.close(-1);}

	w.Parameters.TmTsEt.onChanging = function(){
		w.Parameters.TmTsEt.text = w.Parameters.TmTsEt.text.replace(/[^\d]+/g,'');
		if(w.Parameters.TmTsEt.text.length > 3){
			w.Parameters.TmTsEt.text = w.Parameters.TmTsEt.text.substring(0,3)
		}
	}
	w.Parameters.TmTsAutoCb.onClick = function(){
		w.Parameters.TmTsEt.enabled = !this.value;
	}
	w.cancelBtn.onClick = function () {w.close(-1);}
	w.runBtn.onClick = function () {
		if ((!w.Parameters.TmTsEt.text) && !w.Parameters.TmTsAutoCb.value){
			alert("No font size has been specified. \nActivate automatic font size selection if you are unsure.");
			return;
		}
		w.close(1);
		markTextures(w.Parameters.TmTsEt.text, w.Parameters.TmTsAutoCb.value, w.Parameters.TmFcDd.selection, 1<<parseInt(w.Parameters.TmRsfEt.selection), parseInt(w.Parameters.TmPosDd.selection))
		return
	}
	w.center();
	dlg = w.show();
	return w;
}

function TextureLoadDialog()
{
	var conditionStr =
			"dialog { text: 'HighResEaser CCTEX MOD v"+VERSION+"', bounds:[140,50,580,290], " + 
			"Parameters: Panel { text: 'Texture load parameters', bounds:[10,10,430,200], " +
				"TmRsfSt: StaticText { text:'Resize factor',helpTip:'Allows you to automatically resize textures after loading. Multiples of two are allowed (up to 16x)', justify:'right', bounds:[10,30,90,45]}, " +
				"TmRsfEt: DropDownList { text:'', properties:{multiline:true}, bounds:[100,30,155,50]}, " +
				"fsHrSt: StaticText { text:'Add high-res layer',helpTip:'This option automatically adds a high-res layer to every loaded texture. onto this layer you can paint the high-res version of the texture. Do not forget to merge layers before saving!', justify:'right', bounds:[190,30,280,45]}, " +
				"fsHrCb: Checkbox { text:'',helpTip:'Add a high-res layer to every loaded texture', value:true, bounds:[165,30,180,45]}, " +
				"fsToSt: StaticText { text:'Textures to load',helpTip:'Insert a comma-separated list of the ids of the textures you want to load.', justify:'right', bounds:[10,60,90,75]}, " +		
				"fsToEt: EditText { text:'', properties:{multiline:true}, bounds:[100,60,410,170]}, " +
			"}, " +
			"cancelBtn: Button { text:'Cancel', bounds:[15,210,115,230]}, " + 
			"runBtn: Button { text:'RUN', bounds:[315,210,415,230]}, " + 
	"}";

	var w = new Window(conditionStr);
	w.Parameters.TmRsfEt.add('item', "none")
	w.Parameters.TmRsfEt.add('item', "2x")
	w.Parameters.TmRsfEt.add('item', "4x")
	w.Parameters.TmRsfEt.add('item', "8x")
	w.Parameters.TmRsfEt.add('item', "16x")
	w.Parameters.TmRsfEt.selection = w.Parameters.TmRsfEt.items[0] 
	w.center();
	w.cancelBtn.onClick = function () {w.close(-1);}
	w.Parameters.fsToEt.onChanging = function(){
		w.Parameters.fsToEt.text = w.Parameters.fsToEt.text.replace(/[^\n\r\d ,]+/g,'');
	}
	w.runBtn.onClick = function () {
		if (w.Parameters.fsToEt.text.length < 1){
			alert("At least 1 tile id has to be specified");
			return;
		}
		w.close(1);
		loadSelectedTextures(w.Parameters.fsHrCb.value, w.Parameters.fsToEt.text, 1<<parseInt(w.Parameters.TmRsfEt.selection))
	}
	dlg = w.show();
	return w;
}


function MainDialog()
{
	var conditionStr =
			"dialog { text: 'HighResEaser CCTEX MOD v"+VERSION+"', bounds:[140,50,475,330], " + 
			"Parameters: Panel { text: 'Choose your action:', bounds:[10,10,325,260], " +
			"MarkBtn: Button { text:'1. Load, mark and export original textures', bounds:[15,45,300,70]}, " + 
			"ArrangeBtn: Button { text:'2. Load and arrange marked textures', bounds:[15,80,300,105]}, " + 
			"SliceBtn: Button { text:'3. Split up and save high-res textures', bounds:[15,115,300,140]}, " + 
			"GadgetSt: StaticText { text:'Additional Gadgets:', justify:'left', bounds:[10,160,150,175]}, " +		
			"LoadTextureBtn: Button { text:'Load selected textures', bounds:[15,185,300,210]}, " + 
			"CopyrightSt: StaticText { text:' microdev 2015', helpTip:'You are free to contact me at www.emutalk.net for feedback, bug reports or feature requests.', justify:'right', bounds:[200,225,300,250]}, " +		
			"}, " +
	"}";

	var w = new Window(conditionStr);
	w.Parameters.MarkBtn.onClick = function () {
		w.close(1);
		MarkTextureDialog()
	}
	w.Parameters.ArrangeBtn.onClick = function () {
		w.close(1);
		//CCEXP
		TextureArrangementDialog("NoRobo")
		//CCEXP
	}
	w.Parameters.SliceBtn.onClick = function () {
		w.close(1);
		splitHighRes()
	}
	w.Parameters.LoadTextureBtn.onClick = function () {
		w.close(1);
		TextureLoadDialog()
	}
	w.center();
	dlg = w.show();
	return w;
}


